package com.javacodegeek.demo.controller;

import com.javacodegeek.demo.model.Employee;
import com.javacodegeek.demo.service.EmployeeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

//spring annotations
@RestController
@RequestMapping("/api")
public class EmployeeController {

    @Autowired
    EmployeeService service;

    //http://localhost:9090/api/getall
    @GetMapping("/getall")
    @ResponseStatus(HttpStatus.OK)
    public List<Employee> getEmployees() {
        return service.getEmployees();
    }
}
