package com.javacodegeek.demo.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.stereotype.Component;

import javax.persistence.*;

//spring jpa annotations
@Entity
@Table(name = "employee_tbl")
//lombok annotations
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
//spring annotation
@Component
public class Employee {

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    int id;
    @Column(name = "first_name")
    String firstName;
    @Column(name = "last_name")
    String lastName;
    @Column(name = "email_address")
    String emailAddress;
    String phone;
}
