package com.javacodegeek.demo.service;

import com.javacodegeek.demo.model.Employee;
import com.javacodegeek.demo.repository.EmployeeRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

//lombok annotation
@Slf4j
//spring annotation
@Service
public class EmployeeService {

    @Autowired
    EmployeeRepository repository;

    //save employees in the database
    public void save(final List<Employee> employees) {
        repository.saveAll(employees);
    }

    //get all employees from the database
    public List<Employee> getEmployees() {
        log.info("Getting all employees");
        return repository.findAll();
    }
}
