package com.jcg.assignment;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

// Stream.flatMap() function is used to get a single list containing all elements from a list of lists.

public class Java8FlatmapExample {

    private static void flatMapImplementation() {
        final List<String> teamChelsea = Arrays.asList("Timo Werner", "Mason Mount", "Kai Havertz");
        final List<String> teamPortugal = Arrays.asList("Cristiano Ronaldo", "Pepe", "André Silva");
        final List<String> teamManchester = Arrays.asList("Jadon Sancho", "Paul Pogba");

        final List<String> flatMapList = Stream.of(teamChelsea, teamPortugal, teamManchester)
                .flatMap(Collection::stream)
                .collect(Collectors.toList());

        System.out.println("----- List of all players using Java8 -----");
        flatMapList.forEach(System.out::println);
    }

    public static void main(String[] args) {
        flatMapImplementation();
    }
}
