package com.jcg.assignment;

import java.util.Optional;

public class OptionalFlatmapExample {

    private static void optionalFlatmapExample() {
        final Optional<String> stringOptional = Optional.of("Welcome to javacodegeeks");

        final Optional<String> result = Optional.of(stringOptional)     // Represents two level nested optional instance.
                .flatMap(val -> val.map(String::new));
        System.out.println("Output = " + result.get());
    }

    private static void emptyOptionalExample() {
        final Optional<String> emptyOptional = Optional.empty();

        final Optional<String> result = Optional.of(emptyOptional)      // Represents two level nested optional instance.
                .flatMap(val -> Optional.of("No value found."));
        System.out.println("Output = " + result.get());
    }

    public static void main(String[] args) {
        optionalFlatmapExample();
        emptyOptionalExample();
    }
}
