package com.jcg.mapstruct.mapper;

import com.jcg.mapstruct.dto.CommerceDto;
import com.jcg.mapstruct.model.Commerce;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-07-11T11:12:48+0530",
    comments = "version: 1.4.2.Final, compiler: javac, environment: Java 1.8.0_242 (Amazon.com Inc.)"
)
@Component
public class CommerceMapperImpl implements CommerceMapper {

    @Override
    public CommerceDto modelToDto(Commerce commerce) {
        if ( commerce == null ) {
            return null;
        }

        CommerceDto commerceDto = new CommerceDto();

        commerceDto.setCode( commerce.getPromotionCode() );
        commerceDto.setId( commerce.getId() );
        commerceDto.setName( commerce.getName() );
        commerceDto.setPrice( commerce.getPrice() );
        commerceDto.setRefId( commerce.getRefId() );
        commerceDto.setQuantity( String.valueOf( commerce.getQuantity() ) );

        return commerceDto;
    }

    @Override
    public List<CommerceDto> modelsToDtos(List<Commerce> commerces) {
        if ( commerces == null ) {
            return null;
        }

        List<CommerceDto> list = new ArrayList<CommerceDto>( commerces.size() );
        for ( Commerce commerce : commerces ) {
            list.add( modelToDto( commerce ) );
        }

        return list;
    }

    @Override
    public Commerce dtoToModel(CommerceDto commerceDto) {
        if ( commerceDto == null ) {
            return null;
        }

        Commerce commerce = new Commerce();

        commerce.setPromotionCode( commerceDto.getCode() );
        commerce.setId( commerceDto.getId() );
        commerce.setName( commerceDto.getName() );
        commerce.setPrice( commerceDto.getPrice() );
        commerce.setRefId( commerceDto.getRefId() );
        if ( commerceDto.getQuantity() != null ) {
            commerce.setQuantity( Integer.parseInt( commerceDto.getQuantity() ) );
        }

        return commerce;
    }
}
