package com.java8;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

// java code for Stream.count() to count the elements in the stream
public class Demo1 {

	private static void count(final List<String> names) {
		// using count() to count the number of elements and 
		// saving the result in a variable
		final long count = names.stream().count();
		System.out.println("Count without filter: " + count);
	}
	
	private static void countEmptyStrings(final List<String> names) {
		final long count = names.stream()
				.filter(String::isEmpty)
				.count();
		System.out.println("\nEmpty element(s) count: " + count);
	}
	
	private static void countWithFilters(final List<String> names) {
		final Predicate<String> nameStartsWithA = ele -> ele.startsWith("A");
		final Predicate<String> nameStartsWithJ = ele -> ele.startsWith("J");
		
		final long count = names.stream()
				.filter(nameStartsWithA.or(nameStartsWithJ))
				.count();
		System.out.println("\nCount with filters: " + count);
	}
	
	public static void main(String[] args) {
		// creating a list of names
		final List<String> names = new ArrayList<>();
		names.add("John");
		names.add("Jane");
		names.add("Adam");
		names.add("Mathew");
		names.add("Eve");
		names.add("Kierra");
		names.add("Miranda");
		names.add("Thomas");
		names.add("Alvaro");
		names.add("");
		
		System.out.println("----- count() in Java8 -----\n");
		count(names);
		countEmptyStrings(names);
		countWithFilters(names);
	}
}
