package com.java8;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

/*
 * Stream.min() - Returns the minimum element of this stream according to the provided comparator.
 * Stream.max() - Returns the maximum element of this stream according to the provided comparator.
 */
public class MinMaxDemo1 {
	
	private static void findMinAndMaxForIntegers() {
		System.out.println("---- Min and Max for integer ----");
		
		final List<Integer> integers = Arrays.asList(6, 5, 20, 2, 1);
		// integer comparator
		final Comparator<Integer> comparator = Comparator.comparing(Integer::intValue);
		
		final Optional<Integer> min = integers.stream().min(comparator);
		// handling the sonar issue to perform ifPresent check before fetch
		min.ifPresent(val -> System.out.println("Stream.min():- " + val));
		
		final Optional<Integer> max = integers.stream().max(comparator);
		// handling the sonar issue to perform ifPresent check before fetch
		max.ifPresent(val -> System.out.println("Stream.max():- " + val));
	}
	
	public static void main(String[] args) {
		findMinAndMaxForIntegers();
	}
}
