package com.java8;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

/*
 * Stream.min() - Returns the minimum element of this stream according to the provided comparator.
 * Stream.max() - Returns the maximum element of this stream according to the provided comparator.
 */
public class MinMaxDemo2 {

	private static void findMinAndMaxForStrings() {
		System.out.println("---- Min and Max for string ----");
		
		final List<String> strings = Arrays.asList("A", "F", "Z", "B", "P");
		// string comparator
		final Comparator<String> comparator = Comparator.comparing(String::valueOf);
		
		final Optional<String> min = strings.stream().min(comparator);
		// handling the sonar issue to perform ifPresent check before fetch
		min.ifPresent(val -> System.out.println("Stream.min():- " + val));
		
		final Optional<String> max = strings.stream().max(comparator);
		// handling the sonar issue to perform ifPresent check before fetch
		max.ifPresent(val -> System.out.println("Stream.max():- " + val));
	}
	
	public static void main(String[] args) {
		findMinAndMaxForStrings();
	}
}
