package com.java8;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

/*
 * Stream.min() - Returns the minimum element of this stream according to the provided comparator.
 * Stream.max() - Returns the maximum element of this stream according to the provided comparator.
 */
public class MinMaxDemo3 {

	private static void findMinAndMaxByName(final List<Student> students) {
		System.out.println("\nMin and max student by name");
		// student name comparator
		final Comparator<Student> name = Comparator.comparing(Student::getName);

		final Optional<Student> min = students.stream().min(name);
		// handling the sonar issue to perform ifPresent check before fetch
		min.ifPresent(val -> System.out.println("Stream.min():- " + val.toString()));

		final Optional<Student> max = students.stream().max(name);
		// handling the sonar issue to perform ifPresent check before fetch
		max.ifPresent(val -> System.out.println("Stream.max():- " + val.toString()));
	}

	private static void findMinAndMaxByAge(final List<Student> students) {
		System.out.println("\nMin and max student by age");
		// student age comparator
		final Comparator<Student> age = Comparator.comparing(Student::getAge);

		final Optional<Student> minAge = students.stream().min(age);
		// handling the sonar issue to perform ifPresent check before fetch
		minAge.ifPresent(val -> System.out.println("Stream.min():- " + val.toString()));

		final Optional<Student> maxAge = students.stream().max(age);
		// handling the sonar issue to perform ifPresent check before fetch
		maxAge.ifPresent(val -> System.out.println("Stream.min():- " + val.toString()));
	}

	public static void main(String[] args) {
		System.out.println("---- Min and Max for object ----");
		
		// student list
		final List<Student> students = new ArrayList<>();
		students.add(new Student("John", 41));
		students.add(new Student("Jane", 20));
		students.add(new Student("Adam", 17));
		students.add(new Student("Eve", 3));
		students.add(new Student("Mathew", 10));
		
		findMinAndMaxByName(students);
		findMinAndMaxByAge(students);
	}
}

class Student {
	private final String name;
	private final int age;

	public Student(final String name, final int age) {
		this.name = name;
		this.age = age;
	}

	public String getName() {
		return name;
	}

	public int getAge() {
		return age;
	}

	@Override
	public String toString() {
		return "Student [name=" + name + ", age=" + age + "]";
	}
}
