package com.assignment;

// Consumer functional interface

import com.assignment.com.assignment.util.Student;

import java.util.List;
import java.util.function.Consumer;

public class Example1 {

    // accept() method example
    private static void acceptImplementation() {
        final Consumer<String> stringConsumer = System.out::println;
        stringConsumer.accept("JavaCodeGeeks");
    }

    // andThen() method example
    private static void andThenImplementation() {
        final Consumer<String> first = x -> System.out.println(x.toLowerCase());
        final Consumer<String> second = y -> System.out.println(y.toUpperCase());

        final Consumer<String> result = first.andThen(second);
        result.accept("WebCodeGeeks");
    }

    // forEach() method example
    private static void forEachImplementation() {
        final List<Student> students = Student.createStudents();

        final Consumer<Student> studentConsumer = student -> System.out.println(student.toString());
        students.forEach(studentConsumer);
    }

    public static void main(String[] args) {
        System.out.println("----- Implementing accept() method -----");
        acceptImplementation();

        System.out.println("\n----- Implementing andThen() method -----");
        andThenImplementation();

        System.out.println("\n----- Implementing forEach() method -----");
        forEachImplementation();
    }
}
