package com.java8;

import com.java8.util.Employee;

import java.util.Arrays;
import java.util.List;

public class CountDemo {

    // count() method counts the number of elements in the stream

    private static void method1() {
        List<Integer> list = Arrays.asList(1, 2, 2, 3, 4, 5, 6, 6, 1, 8, 0, 10);

        long total = list.stream()
                .count();
        System.out.println("Total elements = " + total);
    }

    private static void method2() {
        List<Employee> employees = Employee.create();

        long total = employees.stream().count();
        System.out.println("Total employees = " + total);

        long freshers = employees.stream()
                .filter(employee -> employee.getAge() <= 21)
                .count();
        System.out.println("Total employees after filter(..) op = " + freshers);
    }

    // driver code
    public static void main(String[] args) {
        System.out.println("-- Streams count() method --\n");

        method1();

        System.out.println("\n");

        method2();
    }
}
