package com.java8;

import com.java8.util.Employee;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DistinctDemo {

    // distinct() method returns a stream of unique elements
    // uses the hashCode() and equals() method to get the unique elements

    // removing duplicates from primitive type
    private static void method1() {
        List<Integer> duplicates = Arrays.asList(1, 2, 2, 3, 4, 5, 6, 6, 1, 8, 0, 10);
        print("Original list: ", duplicates);

        List<Integer> unique = duplicates.stream()
                .distinct()
                .collect(Collectors.toList());
        print("Distinct list: ", unique);
    }


    // removing duplicates from object
    private static void method2() {
        List<Employee> employees = Employee.create();
        print("Original list: ", employees);

        List<Employee> distinct = employees.stream()
                .filter(distinctByKey(Employee::getEmail))    // using the predicate to remove the duplicated
                .collect(Collectors.toList());
        print("Distinct list: ", distinct);
    }

    // predicate to filter the duplicates by the given key extractor
    // does the job to remove the duplicates
    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        Set<Object> seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    // print the list
    private static void print(String message, List<?> some) {
        System.out.println(message + some);
    }

    // driver code
    public static void main(String[] args) {
        System.out.println("-- Streams distinct() method --\n");

        method1();

        System.out.println("\n");

        method2();
    }
}
