package com.java8;

import com.java8.util.Employee;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class SortedDemo {

	// sorted() method returns a stream consisting of elements in a sorted order
	// it is a stateful intermediate operation

	// sorting primitive type list
	private static void method1() {
		List<Integer> unsorted = Arrays.asList(1, 2, 2, 3, 4, 5, 6, 6, 1, 8, 0, 10);
		System.out.println("Unsorted stream:" + unsorted);

		List<Integer> sorted = unsorted.stream()
				.sorted()
				.collect(Collectors.toList());
		System.out.println("Sorted stream:" + sorted);
	}

	// sorting object list
	private static void method2() {
		List<Employee> employees = Employee.create();

		List<Employee> sorted = employees.stream()
				.sorted(Comparator.comparing(Employee::getAge))    // sorting the employees by age
				.collect(Collectors.toList());
		System.out.println("Sorted list : " + sorted);
	}

	// driver code
	public static void main(String[] args) {
		System.out.println("-- Streams sorted() method --\n");

		method1();

		System.out.println("\n");

		method2();
	}
}
