package com.java8.util;

import java.util.ArrayList;
import java.util.List;

public class Employee {
    private final String email;
    private final int age;

    private Employee(String email, int age) {
        this.email = email;
        this.age = age;
    }

    public static List<Employee> create() {
        List<Employee> employees = new ArrayList<>();
        employees.add(new Employee("john@email.com", 21));
        employees.add(new Employee("martin@email.com", 19));
        employees.add(new Employee("marry@email.com", 31));
        employees.add(new Employee("john@email.com", 27));
        employees.add(new Employee("marry@email.com", 25));

        return employees;
    }

    public String getEmail() {
        return email;
    }

    public int getAge() {
        return age;
    }

    @Override
    public String toString() {
        return "Employee [email=" + email + ", age=" + age + "]";
    }
}