package com.java8;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class LimitDemo {

    // limit() method retrieves the number of elements from the stream truncated to be no longer than given maximum
    // size. it is a intermediate operation
    // syntax - Stream<T> limit(long maxSize);

    private static void method1() {
        // creating a numbers list
        List<Integer> numbers = new ArrayList<>();
        for (int i = 1; i < 51; i++) {
            numbers.add(i);
        }

        int maxSize = 10;
        // taking only first 10 values from stream and converting them into list
        List<Integer> limit10 = numbers.stream()
                .limit(maxSize)
                .collect(Collectors.toList());
        // printing
        System.out.println(limit10);
    }

    // driver code
    public static void main(String[] args) {
    	System.out.println("-- Streams limit() method --\n");
        method1();
    }
}
