import array as arr

# creating array
int_arr = arr.array('i', [1, 2, 3, 4, 5])


def access_elements():
    print('first element = {}'.format(int_arr[0]))
    print('second element = {}'.format(int_arr[1]))
    print('last element = {}'.format(int_arr[-1]))


def size():
    print('array size = {}'.format(len(int_arr)))


def print_elements():
    print('array elements are: ')
    for ele in int_arr:
        print(ele, end=', ')


def add_element():
    # insert() adds element at the given index.
    # elements from the given index are shifted to right by one position.
    index = 0
    value = 7
    int_arr.insert(index, value)
    print('element = {} added at array index = {}'.format(value, index))
    # append() add an element at the end of array.
    value1 = 8
    int_arr.append(value1)
    print('element = {} added at the last'.format(value1))


def remove_element():
    try:
        value = 5
        # remove() removes the given element from the array
        # if not found ValueError is thrown
        int_arr.remove(value)
        print('element = {} removed from array'.format(value))
    except ValueError as e:
        print(e)


def slice_array():
    # slicing returns a new array with the sub_elements while the original array remains unchanged
    print(int_arr[3:])
    # the array slicing in python supports the negative numbers
    print(int_arr[:-2])


def search_element():
    try:
        key = 1
        # index() find the index of first occurrence of element
        # if not found ValueError is thrown
        index = int_arr.index(key)
        print("search key = {} found at index = {} in array".format(key, index))
    except ValueError as e:
        print(e)


def reverse_array():
    int_arr.reverse()
    print("reversed array = {}".format(int_arr))


def count_element():
    element = 4
    count = int_arr.count(element)
    print("count of {} is = {}".format(element, count))


def update_element():
    # use array index with the assignment operator to modify the value at the given index
    # if index is invalid IndexError is thrown
    try:
        index = 3
        value = -9
        int_arr[index] = value
        print('value = {} updated at array index = {}'.format(value, index))
    except IndexError as e:
        print(e)


if __name__ == '__main__':
    access_elements()
    print()

    size()
    print()

    add_element()
    print_elements()
    print()
    print()

    remove_element()
    print_elements()
    print()
    print()

    slice_array()
    print()

    search_element()
    print()

    reverse_array()
    print()

    count_element()
    print()

    update_element()
    print_elements()
