"""
try:
    # Some Code
except:
    # Executed if error in the
    # try block
else:
    # execute if no exception
finally:
    # Some code .....(always executed)
"""


def divide(x, y):
    try:
        result = x / y
        print('result = {}'.format(result))
    except ZeroDivisionError as zde:
        print('some err has occurred.')
        print(zde)


def multi_catch():
    try:
        print('1' + 1)
        print(1 / 0)
    except NameError:
        print('name err has occurred.')
    except ZeroDivisionError:
        print('cannot divide by zero')
    except:
        print('unknown error')


def divide_with_else(x, y):
    try:
        result = x / y
    except ZeroDivisionError as zde:
        print(zde)
    else:
        print('result = {}'.format(result))


def divide_with_finally(x, y):
    try:
        result = x / y
    except ZeroDivisionError as zde:
        print('some err has occurred.')
        print(zde)
    else:
        print('result = {}'.format(result))
    finally:
        print('done')


def raise_exception(x):
    if x < 0:
        raise Exception('Invalid number entered')


if __name__ == '__main__':
    divide(1, 0)
    print('\n')
    multi_catch()
    print('\n')
    divide_with_else(6, 3)
    print('\n')
    divide_with_finally(10, 2)
    print('\n')
    raise_exception(-1)
