package com.jcg.java8;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestRunAsyncMethod {

  //CompletableFuture.runAsync(...) method is used to run the asynchronous tasks, and it returns a completable future.
  //The method returns a CompletableFuture<Void>.

  @Test
  void test_runAsync() throws ExecutionException, InterruptedException {
    CompletableFuture<Void> c =
        CompletableFuture.runAsync(() -> System.out.println("task executing in async mode"));

    Assertions.assertNull(c.get());
  }

  @Test
  void test_runAsyncCallbacksChain() throws ExecutionException, InterruptedException {
    CompletableFuture<Void> c =
        CompletableFuture.runAsync(() -> System.out.println("running runAsync(...) method"))
            .thenRunAsync(() -> System.out.println("running callback chain"));

    Assertions.assertNull(c.get());
  }

  @Test
  void test_runAsyncWithExecutorService() throws ExecutionException, InterruptedException {
    ExecutorService pool = Executors.newFixedThreadPool(2);

    CompletableFuture<Void> c =
        CompletableFuture.runAsync(
            () -> System.out.println("running runAsync(...) method with an executor"), pool);

    Assertions.assertNull(c.get());

    pool.shutdown();
  }
}
