# fast api implementation.
# swagger documentation - http://localhost:5001/docs
# redocs documentation - http://localhost:5001/redoc

import uvicorn
from fastapi import FastAPI, APIRouter

TODOS = [
    {
        "id": 1,
        "text": "Learn about Polymer",
        "created_at": "Mon Apr 26 06:01:55 +0000 2015",
        "Tags": [
            "Web Development",
            "Web Components"
        ],
        "is_complete": "true"
    },
    {
        "id": 2,
        "text": "Watch Pluralsight course on Docker",
        "created_at": "Tue Mar 02 07:01:55 +0000 2015",
        "Tags": [
            "Devops",
            "Docker"
        ],
        "is_complete": "true"
    },
    {
        "id": 3,
        "text": "Complete presentation prep for Aurelia presentation",
        "created_at": "Wed Mar 05 10:01:55 +0000 2015",
        "Tags": [
            "Presentation",
            "Aureia"
        ],
        "is_complete": "false"
    },
    {
        "id": 4,
        "text": "Instrument creation of development environment with Puppet",
        "created_at": "Fri June 30 13:00:00 +0000 2015",
        "Tags": [
            "Devops",
            "Puppet"
        ],
        "is_complete": "false"
    },
    {
        "id": 5,
        "text": "Transition code base to ES6",
        "created_at": "Mon Aug 01 10:00:00 +0000 2015",
        "Tags": [
            "ES6",
            "Web Development"
        ],
        "is_complete": "false"
    }
]

# 1
app = FastAPI(
    title="Hello world app"
)

# 2
api_router = APIRouter()


# 3

# endpoint- http://localhost:5001/
@api_router.get("/", description="health check", status_code=200)
def index():
    return {
        "status": "ok",
        "message": "app is up and running"
    }


# endpoint- http://localhost:5001/todos
@api_router.get("/todos", description="get all todo items", status_code=200)
def get_todos():
    print("Getting all todo list")
    return {
        "status": "ok",
        "items": TODOS
    }


# endpoint- http://localhost:5001/todo/1
@api_router.get("/todo/{key}", description="get todo item by id", status_code=200)
def get_todo(key: int):
    print("Getting todo id={}".format(key))
    result = [todo for todo in TODOS if todo["id"] == key]
    if result:
        return {
            "status": "ok",
            "item": result[0]
        }
    else:
        return {
            "status": "not_found",
            "message": "resource not found"
        }


# 4
app.include_router(api_router)

# driver code
if __name__ == '__main__':
    uvicorn.run(app, host="localhost", port=5001, log_level="debug")
