import sqlite3
from sqlite3 import Error

DATABASE_NAME = "songs.db"


def get_db():
    """ create a database connection to a SQLite database """
    try:
        conn = sqlite3.connect(DATABASE_NAME)
        return conn
    except Error as e:
        print(e)


def create_table():
    tables = [
        """
        CREATE TABLE IF NOT EXISTS songs(id INTEGER PRIMARY KEY AUTOINCREMENT, name TEXT NOT NULL, singer TEXT NOT NULL)
        """
    ]
    db = get_db()
    cursor = db.cursor()
    for table in tables:
        cursor.execute(table)
