import os

from faker import Faker
from flask import Flask, jsonify, request

import controller
from db import create_table

app = Flask(__name__)
faker = Faker()

RESOURCE_NOT_FOUND = "RESOURCE_NOT_FOUND"


# http get endpoint= http://localhost:8000/song/all
@app.route("/song/all", methods=["GET"])
def get_all():
    songs = controller.get_all()
    items = []
    for song in songs:
        items.append({"id": song[0], "name": song[1], "singer": song[2]})

    return jsonify({"songs": items})


# http get endpoint= http://localhost:8000/song/1
@app.route("/song/<key>", methods=["GET"])
def get_by_id(key):
    song = controller.get_by_id(key)
    if song is None:
        return jsonify({"msg": RESOURCE_NOT_FOUND})

    return jsonify({"id": song[0], "name": song[1], "singer": song[2]})


# http delete endpoint= http://localhost:8000/song/1
@app.route("/song/<key>", methods=["DELETE"])
def delete_by_id(key):
    result = controller.delete_by_id(key)
    if not result:
        return jsonify({"msg": RESOURCE_NOT_FOUND})

    return jsonify(result)


# http put endpoint= http://localhost:8000/song/1
@app.route("/song/<key>", methods=["PUT"])
def update_by_id(key):
    details = request.get_json()
    name = details["name"]
    singer = details["singer"]
    result = controller.update_by_id(key, name, singer)
    if not result:
        return jsonify({"msg": RESOURCE_NOT_FOUND})

    return jsonify(result)


if __name__ == '__main__':
    create_table()
    print("Table created")

    if controller.get_row_count() == 0:
        for x in range(1, 6):
            controller.insert_song(faker.word(), faker.name())

        print("Sample records inserted")
    else:
        print("Skipping insert")

    server_port = os.environ.get('PORT_NUMBER', '8000')
    app.run(debug=False, port=server_port, host='0.0.0.0')
