resource "aws_security_group" "ec2-sg" {
  name        = "ec2-sg"
  description = "security group for ec2"
  vpc_id      = "vpc-66d81b0d"
  ingress = [
    {
      # ssh port allowed from any ip
      description      = "ssh"
      from_port        = 22
      to_port          = 22
      protocol         = "tcp"
      cidr_blocks      = ["0.0.0.0/0"]
      ipv6_cidr_blocks = null
      prefix_list_ids  = null
      security_groups  = null
      self             = null
    }
  ]
  egress = [
    {
      description      = "all-open"
      from_port        = 0
      to_port          = 0
      protocol         = "-1"
      cidr_blocks      = ["0.0.0.0/0"]
      ipv6_cidr_blocks = null
      prefix_list_ids  = null
      security_groups  = null
      self             = null
    }
  ]
  tags = {
    "name"      = "terraform-sg"
    "terraform" = "true"
  }
}

resource "aws_instance" "terraforminstance" {
  ami               = "ami-0a23ccb2cdd9286bb" # remember to check for free-tier ami id before runnning the script to avoid unwanted money
  availability_zone = "ap-south-1a"
  instance_type     = "t2.micro"
  key_name          = var.key_name
  count             = 1
  security_groups   = ["${aws_security_group.ec2-sg.id}"]
  subnet_id         = "subnet-c98f67a2"
  ebs_block_device {
    device_name           = "/dev/xvda"
    volume_size           = 8
    volume_type           = "gp2"
    delete_on_termination = true
  }
  tags = var.tags
}
