-- purpose to handle the exception in a postgresql stored procedure
-- sql table
create table if not exists division(
  id serial, 
  val1 int not null, 
  val2 int not null, 
  res numeric not null, 
  primary key(id)
);

-- sql stored procedure
create or replace procedure div_proc(num1 int, num2 int) as 
$$
	declare 
	total numeric;
	begin
		total := num1/num2;
		insert into public.division  (val1, val2, res) values (num1, num2, total);
		raise notice 'Data inserted at %', now();	-- will help in audit logging
	exception when others then
		raise exception 'Cannot divide by zero exception';
		-- raise notice '%, %', sqlstate, sqlerrm;
	end;
$$ language 'plpgsql'


-- calling stored procedure
call div_proc(40, 6);

-- will result in raising exception in stored procedure
call div_proc(100, 0);

-- displaying results
select id, val1, val2, res from division d;

-- deleting stored procedure and table
drop procedure if exists div_proc(num1 int, num2 int);

drop table if exists division;
