-- wildcard in sql --
SELECT id,name,email,phone,company,salary,department from person ORDER BY name ASC;

/*
-- percentage wildcard --
-- matches any sequence of zero or more characters --
%a -> name end with a
a% -> name starts with a
%a% -> name having a in between
*/

-- query1
SELECT id,name,email,phone,company,salary,department FROM person WHERE name LIKE '%a'; 

-- query2
SELECT id,name,email,phone,company,salary,department FROM person WHERE name LIKE 'a%' OR name LIKE 'A%';
-- or
SELECT id,name,email,phone,company,salary,department FROM person WHERE name LIKE any (array['a%', 'A%']);
-- or 
-- ILIKE operator matches the value case-insensitively
SELECT id,name,email,phone,company,salary,department FROM person WHERE name ILIKE 'a%';

-- query3
SELECT id,name,email,phone,company,salary,department FROM person WHERE name LIKE '%a%';

/*
-- underscore operator --
-- matches any single character --
_a% -> beings with any single character followed by a and ends with any number of characters
*/

SELECT id,name,email,phone,company,salary,department FROM person WHERE name LIKE '_a%';
