package org.javacodegeeks.treemap;

import java.util.*;

public class TreeMapExample {

    public static void main(String[] args) {
        TreeMapExample treeMapExample = new TreeMapExample();
        treeMapExample.constructor1();
        treeMapExample.constructor2();
        treeMapExample.constructor3();

        treeMapExample.clear();
        treeMapExample.containsKey();
        treeMapExample.containsValue();
        treeMapExample.removeAndReplace();
    }

    /** Constructs a new, empty tree map, using the natural ordering of its keys */
    private void constructor1() {
        TreeMap<Integer, String> treeMap = new TreeMap();
        treeMap.put(1, "one");
        treeMap.put(2, "two");
        System.out.println("Constructor1: " + treeMap);
    }

    /** Constructs a new, empty tree map, ordered according to the given comparator */
    private void constructor2() {
        TreeMap<Integer, String> treeMap = new TreeMap(Comparator.reverseOrder());
        treeMap.put(2, "two");
        treeMap.put(1, "one");
        System.out.println("Constructor2: " + treeMap);
    }

    /** Constructs a new tree map containing the same mappings as the given map, ordered according to the natural ordering of its keys */
    private void constructor3() {
        Map<String, Integer> map = Map.of("one", 1, "two", 2, "three", 3, "four", 4);
        TreeMap<Integer, String> treeMap = new TreeMap(map);
        System.out.println("Constructor3: " + treeMap);
    }

    // #####################################################################
    // ################# Important methods #################################
    // #####################################################################

    private TreeMap<String, Integer> constructTreeMap() {
        TreeMap<String, Integer> treeMap = new TreeMap();
        treeMap.put("one", 1);
        treeMap.put("two", 2);
        treeMap.put("three", 3);
        treeMap.put("four", 4);
        treeMap.put("five", 5);
        return treeMap;
    }

    private void clear() {
        TreeMap<String, Integer> treeMap = constructTreeMap();
        System.out.println("\nBefore Clearing: " + treeMap);
        treeMap.clear();
        System.out.println("After Clearing: " + treeMap);
    }

    private void containsKey() {
        TreeMap<String, Integer> treeMap = constructTreeMap();
        System.out.println("\nContains key four: " + treeMap.containsKey("four"));
        System.out.println("Does not contains key six: " + treeMap.containsKey("six"));
    }

    private void containsValue() {
        TreeMap<String, Integer> treeMap = constructTreeMap();
        System.out.println("\nContains value 4: " + treeMap.containsValue(4));
        System.out.println("Does not contains value 6: " + treeMap.containsValue(6));
    }

    private void removeAndReplace() {
        TreeMap<String, Integer> treeMap = constructTreeMap();
        treeMap.remove("four");
        System.out.println("\nContains key four: " + treeMap.containsKey("four"));
        treeMap.replace("five", 6);
        System.out.println("Value of five replaced with: " + treeMap.get("five"));
    }
}
