const { ApolloServer } = require("apollo-server-express");
const { typeDefs } = require("./schema/typedefs");
const { resolvers } = require("./schema/resolvers");

const server = new ApolloServer({ typeDefs, resolvers });

const express = require("express");
const app = express();

// browser url - http://localhost:3005/graphql

const app_port = 3005;
server.start().then(() => {
  server.applyMiddleware({ app });
  app.listen({ port: app_port }, () => {
    console.log(`Service endpoint :: http://localhost:${app_port}/graphql`);
  });
});
