const config = require("config");

const table = config.get("database.dev.table");

const knex = require("knex")({
  client: config.get("database.driver"),
  debug: false,
  connection: {
    host: config.get("database.dev.host"),
    user: config.get("database.dev.user"),
    password: config.get("database.dev.password"),
    database: config.get("database.dev.database")
  }
});

const resolvers = {
  Query: {
    getAll: () => {
      console.log("fetching all users");
      return knex(table).select("*");
    },

    find: (parent, args) => {
      let key = args.id;
      console.log("fetching %s", key);
      return knex(table).where("id", key);
    }
  },

  Mutation: {
    create: (parent, args) => {
      console.log("inserting new user");
      knex(table)
        .insert({ name: args.name, email: args.email, age: args.age })
        .returning("id")
        .then(([res]) => {
          console.log("%s inserted", res.id);
        });

      return { status: `inserted` };
    },

    delete: (parent, args) => {
      let key = args.id;
      console.log("deleting %s", key);
      return knex(table)
        .del()
        .where({ id: key })
        .then(() => {
          return { status: `${key} deleted` };
        });
    },

    deleteAll: () => {
      console.log("deleting all");
      return knex(table)
        .del()
        .then(() => {
          return { status: "all records deleted" };
        });
    }
  }
};

module.exports = { resolvers };
