const { gql } = require("apollo-server-express");

const typeDefs = gql`
  type User {
    id: Int!
    name: String!
    email: String!
    age: Int!
  }

  type Link {
    status: String!
  }

  # Queries
  type Query {
    getAll: [User!]!

    find(id: Int!): [User!]!
  }

  # Mutation
  type Mutation {
    create(name: String!, email: String!, age: Int!): Link!

    delete(id: Int!): Link!

    deleteAll: Link!
  }
`;

module.exports = { typeDefs };
