// knex sql query builder tutorial in express js

const express = require("express");
const config = require("config");

const api = require("./routes/routes");

const app = express();
app.use(express.json());

// app endpoints
app.get("/", api.index);
app.get("/getAll", api.getAll);
app.get("/find/:id", api.findOne);
app.post("/save", api.save);
app.delete("/delete/:id", api.deleteOne);
app.put("/update/:id", api.update);

// driver code
const port = config.get("dev.app_port");
app.listen(port, () => {
  console.log(`service endpoint = http://localhost:${port}`);
});
