const knexConfig = require("../config/knexconfig");
const conn = require("knex")(knexConfig);

const config = require("config");
const table = config.get("dev.db.table");

const index = (req, resp) => {
  return resp.status(200).json({ message: "up" });
};

// crud endpoints

const getAll = async (req, resp) => {
  console.log("getting all users");
  try {
    const users = await conn(table).select("*");
    return resp.status(200).json({ data: users });
  } catch (err) {
    error(err, resp);
  }
};

const findOne = async (req, resp) => {
  let key = parseInt(req.params.id);
  console.log("searching user %s", key);
  try {
    const res = await conn(table).where("id", key).select();
    if (res.length === 0)
      return resp.status(400).json({ message: `${key} not found` });
    else return resp.status(200).json({ data: res });
  } catch (err) {
    error(err, resp);
  }
};

const save = async (req, resp) => {
  console.log("saving user");
  const { name, email, age } = req.body;
  try {
    const res = await conn(table)
      .insert({ name: name, email: email, age: age })
      .returning("id");
    return resp.status(201).json({ message: `${res[0].id} created` });
  } catch (err) {
    error(err, resp);
  }
};

const deleteOne = async (req, resp) => {
  let key = parseInt(req.params.id);
  console.log("deleting user %s", key);
  try {
    const res = await conn(table).where("id", key).select();
    if (res.length === 0)
      return resp.status(400).json({ message: `${key} not found` });
    else {
      await conn(table).where({ id: res[0].id }).del();
      return resp.status(202).json({ message: `${res[0].id} deleted` });
    }
  } catch (err) {
    error(err, resp);
  }
};

const update = async (req, resp) => {
  let key = parseInt(req.params.id);
  console.log("updating user %s", key);
  // db part skipped for brevity. you are free to play around
  return resp.status(204).json({ info: `${id} updated` });
};

// helper method

function error(err, resp) {
  console.log(err);
  return resp.status(503).json({ message: "error occurred" });
}

module.exports = {
  index,
  getAll,
  findOne,
  save,
  deleteOne,
  update
};
