-- drop table if exists
drop table demo;

-- create table with jsonb column
create table demo (id serial primary key, data jsonb);

-- describe table structure
select column_name, data_type from information_schema."columns" c where c.table_name = 'demo';

-- insert dummy records into the table
insert into demo (data) values ('{"title": "PostgreSQL for Beginners", "type": ["Programming", "Computer"], "published": true}');
insert into demo (data) values ('{"title": "Harry Potter", "type": ["Novel", "Fantasy"], "published": true}');
insert into demo (data) values ('{"title": "The Pragmatic Programmer", "type": ["Programming", "Computer"], "published": false}');
insert into demo (data) values ('{"title": "The adventure of Sherlock holmes", "type": ["Novel", "Adventure"], "published": true}');
insert into demo (data) values ('{"title": "Learning Java", "type": ["Programming", "Computer"], "published": false}');

-- view all records in table
select * from demo;

-- view record(s) based on a condition
select * from demo where data ->> 'title' like '%Postgre%';
select * from demo where data ->> 'type' like '%Programming%' and data ->> 'published' = 'false';
select * from demo where data ->> 'published' = 'true';

select data -> 'title' as title from demo;
select data -> 'title' as title from demo where data ->> 'published' = 'true';
select data -> 'title' as title, data -> 'type' as genre from demo where data ->> 'published' = 'false';

-- update record(s) based on a condition
update demo set data = data || '{"type": ["Novel", "Fantasy", "Crowd favourite"]}' where data ->> 'title' like '%Harry%';

select * from demo where data ->> 'title' like '%Harry%';

-- delete record(s) based on a condition
delete from demo where data ->> 'published' = 'true';

select * from demo;

-- delete all records
delete from demo;
