-- purpose to understand subquery in postgresql
drop table student;

drop table student_marks;

create table student(
	id serial primary key,
	student_name varchar(50),
	city_name varchar(50)
);
insert into student (student_name, city_name) values ('Ram', 'Agra');
insert into student (student_name, city_name) values ('Aarav', 'Mumbai');
insert into student (student_name, city_name) values ('Abhilash', 'Hyderabad');
insert into student (student_name, city_name) values ('Tessa', 'Delhi');
insert into student (student_name, city_name) values ('Daniel', 'Chennai');
insert into student (student_name, city_name) values ('Jane', 'Agra');
insert into student (student_name, city_name) values ('Nolan', 'Jaipur');
insert into student (student_name, city_name) values ('Ankit', 'Jaipur');
insert into student (student_name, city_name) values ('Robin', 'Hyderabad');
insert into student (student_name, city_name) values ('Tony', 'Agra');

select * from student s;

create table student_marks(
	id serial primary key,
	science int,
	maths int,
	english int
);
insert into student_marks (science, maths, english) values (67, 60, 73);
insert into student_marks (science, maths, english) values (4, 9, 16);
insert into student_marks (science, maths, english) values (8, 20, 55);
insert into student_marks (science, maths, english) values (38, 34, 37);
insert into student_marks (science, maths, english) values (49, 25, 8);
insert into student_marks (science, maths, english) values (71, 52, 94);
insert into student_marks (science, maths, english) values (34, 30, 70);
insert into student_marks (science, maths, english) values (39, 55, 92);
insert into student_marks (science, maths, english) values (72, 91, 49);
insert into student_marks (science, maths, english) values (97, 40, 93);

select * from student_marks sm;

-- SINGLE ROW SUBQUERY
-- returns zeros or one row

-- q: find student marks whose full name is 'Ram' and lives in 'Agra';
select * from student_marks sm where sm.id = (select s.id from student s where s.student_name='Ram' and s.city_name='Agra');

-- MULTIPLE ROWS SUBQUERY
-- returns multiple rows

-- q: find student marks who lives in 'Agra'
select * from student_marks sm where sm.id in (select s.id from student s where s.city_name='Agra');

-- q: find student marks who do not live in 'Agra'
select * from student_marks sm where sm.id not in (select s.id from student s where s.city_name = 'Agra');

-- q: any operator
-- any operator is similar to in operator but offers the use of >, <, and = operators but provided by in keyword
select * from student_marks sm where sm.id =any (select s.id from student s where s.city_name='Agra');

-- INSERT INTO SUBQUERY
-- to select data from one table and insert into another table

create table student_marks_bk(
	id int,
	science int,
	maths int,
	english int,
	total int
);

-- insert into table using select
-- since 'total' column is not present in the 'student_marks_bk' hence in the select query for 'student_marks' we are having a calculated column 'science+maths+english' 
-- to copy the total data in the 'student_marks_bk' table
insert into student_marks_bk(id, science, maths, english, total) select id, science, maths, english, science+maths+english from student_marks;

select * from student_marks_bk smb;

-- delete from 'student_marks_bk' where calculated column 'science+maths+english' value is < 150;
delete from student_marks_bk smb where smb.id in (select sm.id from student_marks sm where (sm.science+sm.maths+sm.english) < 150);

select * from student_marks_bk smb;

-- CORRELATED SUB QUERY
-- used to row-by-row processing i.e. each subquery is executed once for every row of the outer query

create table employee(
	id serial primary key,
	salary numeric
);

insert into employee (salary) values (6000.00);
insert into employee (salary) values (2750.00);
insert into employee (salary) values (2550.00);
insert into employee (salary) values (2650.00);
insert into employee (salary) values (3100.00);

select * from employee;

-- q: find 3rd highest salary from employee
select * from employee e1 where 3=(select count(distinct salary) from employee e2 where e1.salary<=e2.salary);