-- example1: not null and primary key (pk) constraints

-- create table with not null and primary key constraint
create table vehicle(
id serial not null,
name varchar(200) not null,
year_of_manufacturing numeric(4, 0),
primary key(id));

-- the below insert query will get inserted in the vehicle
insert into vehicle (name, year_of_manufacturing) values ('maruti', 1983);

-- the below insert query will not get inserted into the vehicle table as the name is null
-- error: sql error [23502]: error: null value in column "name" of relation "vehicle" violates not-null constraint
insert into vehicle (name, year_of_manufacturing) values (null, 1997);

-- the below select query will print record(s) present in the table
select * from vehicle;


-- example2: unique, default, and primary key (pk) constraints

-- create table with not null, primary key, and default
create table order_details(
id serial not null primary key, 
order_id integer not null, 
order_date timestamp with time zone default current_timestamp, 
quantity integer, 
comments varchar(100), 
constraint order_id_unique unique (order_id));

-- the below insert query will get inserted in the order_details table but order_date will be auto filled because of the default constraint
insert into order_details (order_id, quantity, comments) values (100, 1, 'order1');

-- the below insert query will get inserted in the order_details table but with the user specified date
-- here the default specified for the order_date will not invoked as user date is specified
insert into order_details (order_id, order_date, quantity, comments) values(101, '2021-09-02 10:00:16.198 +0530', 5, 'order2')

-- the below insert query will throw an error because we are trying to duplicate the order_id
-- error: sql error [23505]: error: duplicate key value violates unique constraint "order_id_unique"
insert into order_details (order_id, quantity, comments) values (100, 10, 'order3');

-- the below select query will print record(s) present in the table
select * from order_details;


-- example3: check constraint

-- create table with check constraint
create table salary(
id serial not null primary key,
emp_id int not null,
salary numeric check(salary > 1000));

-- the below insert query will get inserted in the salary table
insert into salary (emp_id, salary) values (1, 5000);

-- the below insert query will get failed because the salary < 1000
-- error: sql error [23514]: error: new row for relation "salary" violates check constraint "salary_salary_check"
insert into salary (emp_id, salary) values (1, 850);

select * from salary;


-- example4: foreign key constraint

create table customer(
id serial not null primary key,
name varchar(200));

create table contact(
id serial not null primary key,
customer_id int,
phone varchar(100),
constraint fk_customer foreign key(id) references customer(id));

select * from customer;

select * from contact;

-- record gets inserted to the customer
insert into customer (name) values ('james');

-- record gets inserted as the customer_id 1 is present in the customer table
insert into contact (customer_id, phone) values (1, '1234567890');

-- record will not get inserted as the customer_id 2 is not present in the customer table
-- error: sql error [23503]: error: insert or update on table "contact" violates foreign key constraint "fk_customer"
insert into contact (customer_id, phone) values (2, '0987654321');
