const express = require("express");
const cors = require("cors");

const dotenv = require("dotenv");
dotenv.config();

const app = express();
app.use(express.json());
app.use(
  cors({
    origin: "*" // helps to receive a request from any domain
  })
);

app.get("/", (req, res) => {
  res.status(200).json({ data: "backend for reactjs is running" });
});

const db = require("./users");

// http get endpoint - http://localhost:9500/health
app.get("/health", db.health);
// http get endpoint - http://localhost:9500/all
app.get("/all", db.getUsers);
// http get endpoint - http://localhost:9500/id/SOME_USER_ID
app.get("/id/:id", db.getById);
// http post endpoint - http://localhost:9500/create
app.post("/create", db.createUser);
// http delete endpoint - http://localhost:9500/id/SOME_USER_ID
app.delete("/id/:id", db.deleteUser);
// http update endpoint - http://localhost:9500/id/SOME_USER_ID
app.put("/id/:id", db.updateUser);

const PORT = process.env.PORT || 3000;
app.listen(PORT, () => {
  console.log(`app running on http://localhost:${PORT}`);
});
