const Pool = require("pg").Pool;

// you're free to change the database details as per your setup
// reading it from the .env file or using default in case the file is missing
const pool = new Pool({
  user: process.env.DATABASE_USER || "postgres",
  host: "localhost",
  database: process.env.DATABASE || "learning",
  password: process.env.DATABASE_PASSWORD || "p@S$w0rd@123!",
  port: 5432
});

const health = (req, res) => {
  pool.query("select version()", (err, result) => {
    if (err) {
      console.log("err in getting db health", err);
      throw err;
    }

    return res.status(200).json({ data: result.rows[0].version });
  });
};

const getUsers = (req, res) => {
  pool.query("select id, name, email, age from users", (err, result) => {
    if (err) {
      console.log("err in fetching all users", err);
      throw err;
    }
    // todo - add atom links for each user
    return res.status(200).json({ data: result.rows });
  });
};

const getById = (req, res) => {
  const id = parseInt(req.params.id);
  pool.query(
    "select id, name, email, age from users where id = $1",
    [id],
    (err, result) => {
      if (err) {
        console.log(err);
        throw err;
      }

      let rowCount = result.rowCount;
      let statusCode = rowCount === 0 ? 404 : 200;
      // todo - add atom links
      let statusText = rowCount === 0 ? "Resource not found" : result.rows;
      return res.status(statusCode).json({ data: statusText });
    }
  );
};

const createUser = (req, res) => {
  const { name, email, age } = req.body;
  pool.query(
    "insert into users (name, email, age) values ($1, $2, $3) returning *",
    [name, email, age],
    (err, result) => {
      if (err) {
        console.log(err);
        throw err;
      }

      return res.status(201).json({
        msg: "data created successfully",
        links: [
          { name: "all", method: "GET", href: "/all" },
          { name: "get", method: "GET", href: `/id/${result.rows[0].id}` },
          { name: "update", method: "PUT", href: `/id/${result.rows[0].id}` },
          { name: "delete", method: "DELETE", href: `/id/${result.rows[0].id}` }
        ]
      });
    }
  );
};

const deleteUser = (req, res) => {
  const id = parseInt(req.params.id);
  pool.query("delete from users where id = $1", [id], (err, result) => {
    if (err) {
      console.log(err);
      throw err;
    }

    let rowCount = result.rowCount;
    let statusCode = rowCount === 0 ? 404 : 204;
    let statusText =
      rowCount === 0
        ? "Resource not found"
        : `Resource ${id} deleted successfully`;
    return res.status(statusCode).json({ data: statusText });
  });
};

const updateUser = (req, res) => {
  return res.status(501).json({ data: "not_yet_implemented" });
};

module.exports = {
  health,
  getUsers,
  getById,
  createUser,
  deleteUser,
  updateUser
};
