import React, { useState } from "react";
import "./App.css";

// a separate nodejs application is running in backend

function App() {
  let [data, setData] = useState(null);
  let [status, setStatus] = useState(null);

  async function getUsers() {
    setStatus(null); // clear status on retrigger
    try {
      // get all users endpoint
      const res = await fetch("http://localhost:9500/all");
      if (!res.ok) throw new Error("Some error has occurred.");

      const users = await res.json();
      setData(users.data);
    } catch (err) {
      // console.log("error occurred", err);
      setStatus({
        type: "error",
        message: err.message,
      });
    }
  }

  async function deleteUser(param) {
    setStatus(null); // clear status on retrigger
    try {
      // delete user endpoint
      const res = await fetch(`http://localhost:9500/id/${param}`, {
        method: "delete",
      });

      setStatus({
        type: "pass",
        status: res.status,
        message: `${param} deleted`,
      });

      // if deletion is success reload the table after x seconds
      setTimeout(function () {
        getUsers();
      }, 3000);
    } catch (err) {
      // console.log("error occurred", err);
      setStatus({
        type: "fail",
        message: err.message,
      });
    }
  }

  return (
    <div className="App">
      <h1>React crud - FETCH and DELETE example</h1>
      <button onClick={getUsers}>Get all users</button>
      <div id="data">
        {data !== null && data.length > 0 && (
          <table className="usersTbl" border="1">
            <thead>
              <tr>
                <td>
                  <strong>Id</strong>
                </td>
                <td>Name</td>
                <td>Email</td>
                <td>Age</td>
                <td>Delete</td>
              </tr>
            </thead>
            <tbody>
              {data.map((item, i) => (
                <tr key={i}>
                  <td>{item.id}</td>
                  <td>{item.name}</td>
                  <td>{item.email}</td>
                  <td>{item.age}</td>
                  <td>
                    <button onClick={() => deleteUser(item.id)}>
                      Click me
                    </button>
                  </td>
                </tr>
              ))}
            </tbody>
          </table>
        )}

        {data !== null && data.length === 0 && <p>No items were found...</p>}
      </div>
      <div id="message">
        {status !== null && status?.type === "pass" && (
          <p>
            Resource {status?.message}. Status_code= {status?.status}
          </p>
        )}
        {status !== null && status?.type === "fail" && <p>{status?.message}</p>}
      </div>
    </div>
  );
}

export default App;
