package com.learning;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

class Person {

  private final int id;
  private final String name;

  public Person(int id, String name) {
    this.id = id;
    this.name = name;
  }

  public int getId() {
    return id;
  }

  public String getName() {
    return name;
  }

  @Override
  public String toString() {
    return "Id= " + getId() + ", Name= " + getName();
  }
}


public class JavaStreamApiListToMap {

  public final static List<Person> persons = new ArrayList<>();

  static {
    for (int i = 0; i < 10; i++) {
      persons.add(new Person(i + 1, "Alpha-" + i + 1));
    }
  }

  public static void main(String[] args) {
    // convert object list to int, object map
    Map<Integer, Person> personMap = convertToMap();
    personMap.forEach(
        (key, value) -> System.out.println("id= " + key + " :: person[" + value.toString() + "]"));
    
    System.out.println("\n");

    // convert object list to int, string map
    Map<Integer, String> personMap1 = convertToMap1();
    personMap1.forEach((key, value) -> System.out.println("id= " + key + " :: value= " + value));
  }

  // method1
  private static Map<Integer, Person> convertToMap() {
    return persons.stream().collect(Collectors.toMap(Person::getId, Function.identity()));
  }

  // method2
  private static Map<Integer, String> convertToMap1() {
    return persons.stream().collect(Collectors.toMap(Person::getId, Person::getName));
  }
}
