package org.javacodegeeks;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

import static org.junit.Assert.assertEquals;

public class ApplicationTest_JUnit4 {

    @Rule public ExpectedException exceptionRule = ExpectedException.none();

    private Application application = new Application();

    @Test
    public void testExceptionThrown_tryCatch() {
        try {
            application.divide(2, 0);
            Assert.fail();
        } catch (IllegalArgumentException e) {
            // Expected
            assertEquals("Divisor can't be zero", e.getMessage());
        }
    }

    @Test(expected = IllegalArgumentException.class)
    public void testExceptionThrown_annotation() {
        application.divide(2, 0);
    }

    @Test
    public void testExceptionThrown_rule() {
        exceptionRule.expect(IllegalArgumentException.class);
        exceptionRule.expectMessage("Divisor can't be zero");
        application.divide(2, 0);
    }

}