package com.learning;

public class MyDemo {
    
    public static List<List<Integer>> subsetsWithTargetSum(int[] nums, int targetSum) {
        List<List<Integer>> result = new ArrayList<>();
        backtrack(nums, targetSum, 0, new ArrayList<Integer>(), result);
        return result;
    }

    private static void backtrack(int[] nums, int targetSum, int index, List<Integer> subset, List<List<Integer>> result) {
        if (targetSum == 0) {
            result.add(new ArrayList<>(subset));
            return;
        }

        for (int i = index; i < nums.length; i++) {
            int num = nums[i];
            if (targetSum - num >= 0) {
                subset.add(num);
                backtrack(nums, targetSum - num, i + 1, subset, result);
                subset.remove(subset.size() - 1);
            }
        }
    }


    public static void main(String[] args) {
        int[] myIntArray = {1, 3, 7, 5, 4, 0, 7, 5};
        int targetSum = 4;

        subsetsWithTargetSum(myIntArray, targetSum);
    }
}