package com.example.demo.controller;

import com.example.demo.model.Example;
import com.example.demo.repository.ExampleRepository;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * The type Example controller.
 */
@RestController
@RequestMapping("/api")
public class ExampleController {

    private final ExampleRepository exampleRepository;

    /**
     * Instantiates a new Example controller.
     *
     * @param exampleRepository the example repository
     */
    public ExampleController(ExampleRepository exampleRepository) {
        this.exampleRepository = exampleRepository;
    }

    /**
     * Gets messages.
     * curl --location 'http://localhost:9099/api/messages'
     *
     * @return the messages
     */
    @GetMapping("/messages")
    public List<Example> getMessages() {
        List<Example> examples = exampleRepository.findAll();
        // Print all post example
        examples.forEach(example -> System.out.println("Id: " + example.getId() + ", Message: " + example.getMessage()));
        return examples;
    }

    /**
     * Add message example.
     * curl --location 'http://localhost:9099/api/messages' --header 'Content-Type: application/json' --data '{"message":"{{$randomLoremWords}}!"}'
     *
     * @param message the message
     * @return the example
     */
    @PostMapping("/messages")
    public Example addMessage(@RequestBody String message) {
        Example example = new Example();
        example.setMessage(message);
        return exampleRepository.save(example);
    }
}
