import java.util.Locale;

public class LocaleExample {
    public static void main(String[] args) {
        String input = "İstanbul";

        // Convert to lowercase using the default locale
        String lowercaseDefaultLocale = input.toLowerCase();
        System.out.println(lowercaseDefaultLocale); 	// Output: i̇stanbul

        // Convert to lowercase using the Turkish locale
        String lowercaseTurkishLocale = input.toLowerCase(new Locale("tr", "TR"));
        System.out.println(lowercaseTurkishLocale); 	// Output: i̇stanbul

        // Convert to lowercase using the English locale
        String lowercaseEnglishLocale = input.toLowerCase(Locale.ENGLISH);
        System.out.println(lowercaseEnglishLocale); 		// Output: i̇stanbul
    }
}
