package jcg.example;

import jdk.incubator.vector.*;

public class VectorComputationExample {
    public static void main(String[] args) {
        // Create a vector species for float values
        VectorSpecies<Float> species = FloatVector.SPECIES_PREFERRED;

        // Input arrays
        float[] array1 = {1.0f, 2.0f, 3.0f, 4.0f};
        float[] array2 = {5.0f, 6.0f, 7.0f, 8.0f};

        // Create vector instances from input arrays
        try (FloatVector vec1 = FloatVector.fromArray(species, array1, 0);
             FloatVector vec2 = FloatVector.fromArray(species, array2, 0);
             FloatVector sumVec = vec1.add(vec2)) {
            // Store the result back to an array
            sumVec.intoArray(array1, 0);

            // Print the result
            for (float value : array1) {
                System.out.println(value);
            }
        }
    }
}


// Output
6.0
8.0
10.0
12.0
