package org.jcg.consumer;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
public class KafkaConsumerV1 {

    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;

    @Value("${spring.kafka.topic-name}")
    private String topicName;

    @KafkaListener(topics = "${spring.kafka.topic-name}")
    public void receiveMessage(String message) {
        System.out.println("Received message: " + message);
        // Perform further processing of the received message

        // Send acknowledgment back to Kafka topic
        sendAcknowledgment(message);
    }

    private void sendAcknowledgment(String message) {
        kafkaTemplate.send(topicName, "Acknowledgement: " + message);
        System.out.println("Acknowledgement sent for message: " + message);
    }
}
