package com.sampletest;

import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class TarExtractionExample {

    public static void main(String[] args) {
        // Path to the Tar Gzip file
        String tarGzipFilePath = "path/to/your/tar_gzip_file.tar.gz";

        // Output directory where the extracted files will be placed
        String outputDirectory = "path/to/output/directory/";

        try {
            // Create a FileInputStream for the Tar Gzip file
            FileInputStream fis = new FileInputStream(tarGzipFilePath);

            // Wrap the FileInputStream with GzipCompressorInputStream to decompress the file
            BufferedInputStream bis = new BufferedInputStream(fis);
            GzipCompressorInputStream gzis = new GzipCompressorInputStream(bis);

            // Wrap GzipCompressorInputStream with TarArchiveInputStream to extract Tar entries
            TarArchiveInputStream tarInput = new TarArchiveInputStream(gzis);

            ArchiveEntry entry;
            while ((entry = tarInput.getNextEntry()) != null) {
                // Get the name of the entry (file or directory)
                String entryName = entry.getName();

                // Create the output file for the entry
                File outputFile = new File(outputDirectory, entryName);

                // If the entry is a directory, create the directory
                if (entry.isDirectory()) {
                    outputFile.mkdirs();
                } else {
                    // If the entry is a file, create parent directories and extract the file
                    outputFile.getParentFile().mkdirs();
                    FileOutputStream fos = new FileOutputStream(outputFile);
                    byte[] buffer = new byte[1024];
                    int bytesRead;
                    while ((bytesRead = tarInput.read(buffer)) != -1) {
                        fos.write(buffer, 0, bytesRead);
                    }
                    fos.close();
                }
            }

            // Close the TarArchiveInputStream
            tarInput.close();

            System.out.println("Tar archive extraction complete.");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
