package com.sampletest;

import org.apache.commons.vfs2.*;

public class TarExtractionExample2 {

    public static void main(String[] args) {
        // Path to the Tar file
        String tarFilePath = "path/to/your/tar_file.tar";

        // Output directory where the extracted files will be placed
        String outputDirectory = "path/to/output/directory/";

        try {
            // Create the VFS Manager
            FileSystemManager fsManager = VFS.getManager();

            // Create a FileObject representing the Tar file
            FileObject tarFile = fsManager.resolveFile(tarFilePath);

            // Create the output directory if it doesn't exist
            FileObject outputDir = fsManager.resolveFile(outputDirectory);
            outputDir.createFolder();

            // Extract the contents of the Tar file
            FileObject[] children = tarFile.getChildren();
            for (FileObject child : children) {
                FileObject destination = fsManager.resolveFile(outputDir, child.getName().getBaseName());
                destination.copyFrom(child, Selectors.SELECT_SELF);
            }

            System.out.println("Tar archive extraction complete.");
        } catch (FileSystemException e) {
            e.printStackTrace();
        }
    }
}
