/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 */
package com.omosmicrosystems.converttimezones;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

/**
 *
 * @author omozegieaziegbe
 */
public class ConvertTimezones {

    private static final String DATE_FORMAT = "dd-MM-yyyy HH:mm:ss.SSS z";

    public static void main(String[] args) throws ParseException {

        SimpleDateFormat africaFormat = new SimpleDateFormat(DATE_FORMAT);

        Date date = new Date();
        String todaysDate = africaFormat.format(date);
        TimeZone timezone = TimeZone.getDefault();

        // Convert from TimeZone in Africa/Lagos
        System.out.println("TimeZone : " + timezone.getID() + " use " + timezone.getDisplayName());
        System.out.println("Time in Lagos, Nigeria : " + todaysDate);

        // To TimeZone in America/Edmonton
        SimpleDateFormat americaFormat = new SimpleDateFormat(DATE_FORMAT);
        TimeZone timezoneAmerica = TimeZone.getTimeZone("America/Edmonton");
        americaFormat.setTimeZone(timezoneAmerica);

        String sDateInEurope = americaFormat.format(date);
        Date dateInAmerica = africaFormat.parse(sDateInEurope); 

        System.out.println("\nTimeZone : " + timezoneAmerica.getID() + " use " + timezoneAmerica.getDisplayName());      
        System.out.println("Time in Edmonton, AB, Canada : " + africaFormat.format(dateInAmerica));

    }

}
