/*
 * Click nbfs://nbhost/SystemFileSystem/Templates/Licenses/license-default.txt to change this license
 */
package com.omosmicrosystems.daylightsavings;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DaylightSavings {
    
    public static void main(String[] args) throws ParseException {
 
        SimpleDateFormat sourceFormat = new SimpleDateFormat("dd-MM-yyyy");
        SimpleDateFormat targetFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'+|-hh:mm");
        String withDLS = "10-03-2023"; 
        String withOutDLS = "11-03-2023";
        try {
            Date dateWithDLS = sourceFormat.parse(withDLS);
            Date dateWithOutDLS = sourceFormat.parse(withOutDLS);
            System.out.println("Default Timezone with Day Light Saving :" + targetFormat.format(dateWithDLS));
            System.out.println("Default Timezone without Day Light Saving :" + targetFormat.format(dateWithOutDLS));

            sourceFormat.setTimeZone(TimeZone.getTimeZone("America/Edmonton"));
            dateWithDLS = sourceFormat.parse(withDLS);
            dateWithOutDLS = sourceFormat.parse(withOutDLS);
            System.out.println("America/Edmonton Timezone with Day Light Saving :" + targetFormat.format(dateWithDLS));
            System.out.println(
                    "America/Edmonton Timezone without Day Light Saving :" + targetFormat.format(dateWithOutDLS));
        } catch (ParseException ex) {
            ex.printStackTrace();
        }
    }
}
