package com.example.demo.controller;

import com.example.demo.dto.FileUploadResponse;
import com.example.demo.util.FileUploadUtil;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;

/**
 * The type File upload controller.
 */
@RestController
public class FileUploadController {

    /**
     * Upload response entity.
     *
     * @param multipartFile the multipart file
     * @return the response entity
     * @throws IOException the io exception
     */
    @PostMapping(value = "/upload")
    public ResponseEntity<FileUploadResponse> upload(@RequestParam("file") MultipartFile multipartFile)
            throws IOException {
        String filename = StringUtils.cleanPath(multipartFile.getOriginalFilename());
        long size = multipartFile.getSize();

        String fileCode = FileUploadUtil.saveFile(filename, multipartFile);
        FileUploadResponse response = new FileUploadResponse(filename, "/download/" + fileCode, size);
        return ResponseEntity.ok(response);
    }

    /**
     * Download response entity.
     *
     * @param fileCode the file code
     * @return the response entity
     */
    @PostMapping(value = "/download")
    public ResponseEntity<?> download(@PathVariable(value = "fileCode") String fileCode) {
        // YET_TO_BE_IMPLEMENTED
        return ResponseEntity.ok().build();
    }
}
