package com.example.demo.dto;

/**
 * The type File upload response.
 */
public class FileUploadResponse {

    private final String name;
    private final String downloadUrl;
    private final long size;

    /**
     * Instantiates a new File upload response.
     *
     * @param name        the name
     * @param downloadUrl the download url
     * @param size        the size
     */
    public FileUploadResponse(String name, String downloadUrl, long size) {
        this.name = name;
        this.downloadUrl = downloadUrl;
        this.size = size;
    }

    /**
     * Gets name.
     *
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Gets download url.
     *
     * @return the download url
     */
    public String getDownloadUrl() {
        return downloadUrl;
    }

    /**
     * Gets size.
     *
     * @return the size
     */
    public long getSize() {
        return size;
    }
}
